<?php

use Illuminate\Support\Facades\Route;
use Plugins\SAMBans\Controllers\BansController;

/*
|--------------------------------------------------------------------------
| SAM Bans Plugin Routes
|--------------------------------------------------------------------------
|
| Routes for the SAM Bans plugin. These routes are automatically
| prefixed with /bans and use the 'web' and 'auth' middleware.
|
*/

// Main bans listing
Route::get('/', [BansController::class, 'index'])->name('sambans.index');

// Ban details
Route::get('/ban/{steamid}', [BansController::class, 'show'])->name('sambans.show');

// Players listing
Route::get('/players', [BansController::class, 'players'])->name('sambans.players');

// Statistics
Route::get('/statistics', [BansController::class, 'statistics'])->name('sambans.statistics');

// API routes for AJAX requests
Route::prefix('api')->group(function () {
    Route::get('/bans', [BansController::class, 'index'])->name('sambans.api.bans');
    Route::get('/ban/{steamid}', [BansController::class, 'show'])->name('sambans.api.ban');
    Route::get('/statistics', [BansController::class, 'statistics'])->name('sambans.api.statistics');
});